﻿<?php
/****************************************
 * XKLog RSS 订阅
 *
 * 此文件提供 RSS 订阅支持
 *
 * 更新：2009-06-09
 * 版本：V1.0
 ****************************************/

require('include/loader.php');
@header("content-Type: text/xml; charset=utf-8");

$cate_id = getGP( 'cate' , $method = 'G', $type = 'int' );
$blog_url = $_CACHE['set'][0]['Domain'];
$title = $_CACHE['set'][0]['BlogName'];
$description = $_CACHE['set'][0]['Description'];
$type = 'all';
$url = $blog_url;

if ( array_key_exists( $cate_id , $_CACHE['category'] ) ) {
	$title = $_CACHE['category'][$cate_id]['Name'] . ' - ' . $title;
	$description = $_CACHE['category'][$cate_id]['Description'];
	$url .= 'rss.php?cate=' . $cate_id;
	$sql = "SELECT A.ID,A.Title,A.Time,A.Author,A.Category,A.Tag,A.Summary,A.Content,A.Read,A.Comment,A.Type,A.Address,A.Update,C.Name,C.Description FROM `" . PREFIX_STR . "Article` A JOIN `" . PREFIX_STR . "Category` C ON A.Category = C.CID WHERE A.IsDel = 0 AND A.Category = " . $cate_id . " ORDER BY A.IsTop DESC,A.ID DESC LIMIT 10";
} else {
	$sql = "SELECT A.ID,A.Title,A.Time,A.Author,A.Category,A.Tag,A.Summary,A.Content,A.Read,A.Comment,A.Type,A.Address,A.Update,C.Name,C.Description FROM `" . PREFIX_STR . "Article` A JOIN `" . PREFIX_STR . "Category` C ON A.Category = C.CID WHERE A.IsDel = 0 ORDER BY A.IsTop DESC,A.ID DESC LIMIT 10";
}

$rssdata = array();
$query = $db->query($sql);
while ($row = $db->fetch_array($query)) {
	if( $row['Type'] == '动态' ){
		$address = $blog_url . BLOG_PATH . 'read.php?id=' . $row['ID'];
	}else{
		$address = $blog_url . BLOG_PATH . 'article/' . $row['Category'] . '/' . $row['Address'] ;
	}
	$rssdata[] = array(
		'title' => $row['Title'],
		'author' => $row['Author'],
		'address' => $address,
		'description' => $row['Content'],
		'category' => $row['Name'],
		'pubDate' => get_date('r',$row['Time'])
	);
}
unset($sql,$query,$row,$address);

echo '<?'.'xml version="1.0" encoding="utf-8"?'.'>',"\n";
?>
<rss version="2.0" xmlns:content="http://purl.org/rss/1.0/modules/content/" xmlns:wfw="http://wellformedweb.org/CommentAPI/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:atom="http://www.w3.org/2005/Atom" xmlns:sy="http://purl.org/rss/1.0/modules/syndication/" >
<channel>
	<title><?php echo $title ?></title>
	<link><?php echo $url ?></link>
	<description><?php echo $description ?></description>
	<language>zh-cn</language>
	<copyright>Powered By XKLog V<?php echo XKLOG_VERSION ?>.Copyright <?php echo get_date('Y',PHP_TIME)?> <?php echo $_CACHE['set'][0]['BlogName'] ?> All Rights Reserved.</copyright>
	<pubDate><?php echo get_date('r',PHP_TIME)?></pubDate>
	<generator>XKLog V<?php echo XKLOG_VERSION?></generator>
	<?php
	foreach ($rssdata as $rss) {
	?>

	<item>
		<title><![CDATA[<?php echo $rss['title']?>]]></title>
		<link><?php echo $rss['address']?></link>
		<author><?php echo $rss['author']?></author>
		<description><![CDATA[<?php echo $rss['description']?>]]></description>
		<category><?php echo $rss['category']?></category>
		<guid><?php echo $rss['address']?></guid>
		<pubDate><?php echo $rss['pubDate']?></pubDate>
	</item>

	<?php
	}
	?>
</channel>
</rss>